/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigInteger;

public class SGVetter {
    private static final long MINIMUM_CACHED_VALUE_COUNT = 1L;
    private boolean _CAN_CYCLE;
    private BigInteger _STEP;
    private BigInteger _MAX;
    private BigInteger _MIN;
    private BigInteger _RESTART;
    private long _ALLOCATION_COUNT;
    private boolean _INCREASING;
    private BigInteger _currentValue;
    private long _valuesRemaining;
    private BigInteger _upperBound;

    public SGVetter(Long currentValue, boolean canCycle, long step, long max, long min, long restart, long allocationCount) throws Exception {
        if (step >= max) {
            throw new IllegalArgumentException();
        }
        if (step <= min) {
            throw new IllegalArgumentException();
        }
        if (restart > max) {
            throw new IllegalArgumentException();
        }
        if (restart < min) {
            throw new IllegalArgumentException();
        }
        if (currentValue != null) {
            if (currentValue > max) {
                throw new IllegalArgumentException();
            }
            if (currentValue < min) {
                throw new IllegalArgumentException();
            }
        }
        this._currentValue = currentValue == null ? null : BigInteger.valueOf(currentValue);
        this._CAN_CYCLE = canCycle;
        this._STEP = BigInteger.valueOf(step);
        this._MAX = BigInteger.valueOf(max);
        this._MIN = BigInteger.valueOf(min);
        this._RESTART = BigInteger.valueOf(restart);
        this._ALLOCATION_COUNT = allocationCount;
        this._INCREASING = this._STEP.compareTo(BigInteger.valueOf(0L)) > 0;
        this._upperBound = this._currentValue;
        this._valuesRemaining = 1L;
    }

    public Long getNextValue() {
        if (this._currentValue == null) {
            return null;
        }
        BigInteger retval = this.cloneBigInteger(this._currentValue);
        this.advance();
        return retval.longValue();
    }

    public Long getUpperBound() {
        if (this._upperBound == null) {
            return null;
        }
        return this._upperBound.longValue();
    }

    private void advance() {
        boolean overflowed;
        BigInteger newValue = this.bump(this._currentValue);
        boolean bl = overflowed = newValue.compareTo(this._currentValue) == 0;
        if (overflowed && !this._CAN_CYCLE) {
            this._currentValue = null;
            this._upperBound = null;
            return;
        }
        --this._valuesRemaining;
        if (this._valuesRemaining < 1L) {
            for (long i = 0L; i < this._ALLOCATION_COUNT; ++i) {
                this._upperBound = this.bump(this._upperBound);
            }
            this._valuesRemaining = this._ALLOCATION_COUNT;
        }
        this._currentValue = newValue;
    }

    private BigInteger bump(BigInteger original) {
        BigInteger newValue = original.add(this._STEP);
        if (this.overflowed(newValue)) {
            newValue = !this._CAN_CYCLE ? this.cloneBigInteger(original) : this._RESTART;
        }
        return newValue;
    }

    private boolean overflowed(BigInteger newValue) {
        boolean overflowed = this._INCREASING ? newValue.compareTo(this._MAX) > 0 : newValue.compareTo(this._MIN) < 0;
        return overflowed;
    }

    private BigInteger cloneBigInteger(BigInteger original) {
        return new BigInteger(original.toByteArray());
    }
}

