/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.junit.Test;

public class TestFileChangedReloadingStrategy {
    private static final String TEST_FILE = "test.properties";

    @Test
    public void testAutomaticReloading() throws Exception {
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        PropertiesConfiguration config = new PropertiesConfiguration("target/testReload.properties");
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertEquals((String)"Initial value", (Object)"value1", (Object)config.getString("string"));
        Thread.sleep(2000L);
        out = new FileWriter(file);
        out.write("string=value2");
        out.flush();
        out.close();
        Assert.assertEquals((String)"Modified value with enabled reloading", (Object)"value2", (Object)config.getString("string"));
    }

    @Test
    public void testNewFileReloading() throws Exception {
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setFile(file);
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertNull((String)"Initial value", (Object)config.getString("string"));
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Modified value with enabled reloading", (Object)"value1", (Object)config.getString("string"));
    }

    @Test
    public void testGetRefreshDelay() {
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        Assert.assertEquals((String)"refresh delay", (long)500L, (long)strategy.getRefreshDelay());
    }

    @Test
    public void testFromClassPath() throws Exception {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setFileName(TEST_FILE);
        config.load();
        Assert.assertTrue((boolean)config.getBoolean("configuration.loaded"));
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertEquals((Object)config.getURL().toExternalForm(), (Object)strategy.getFile().toURI().toURL().toExternalForm());
    }

    @Test
    public void testFromJar() throws Exception {
        XMLConfiguration config = new XMLConfiguration();
        config.setURL(new URL("jar:" + new File("conf/resources.jar").getAbsoluteFile().toURI().toURL() + "!/test-jar.xml"));
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        File file = strategy.getFile();
        Assert.assertNotNull((String)"Strategy's file is null", (Object)file);
        Assert.assertEquals((String)"Strategy does not monitor the jar file", (Object)"resources.jar", (Object)file.getName());
    }

    @Test
    public void testReloadingRequiredMultipleTimes() throws ConfigurationException {
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy(){

            protected boolean hasChanged() {
                return true;
            }
        };
        strategy.setRefreshDelay(100000L);
        PropertiesConfiguration config = new PropertiesConfiguration(TEST_FILE);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertTrue((String)"Reloading not required", (boolean)strategy.reloadingRequired());
        Assert.assertTrue((String)"Reloading no more required", (boolean)strategy.reloadingRequired());
        strategy.reloadingPerformed();
        Assert.assertFalse((String)"Reloading still required", (boolean)strategy.reloadingRequired());
    }

    @Test
    public void testFileDeletion() throws Exception {
        Logger logger = Logger.getLogger((String)FileChangedReloadingStrategy.class.getName());
        PatternLayout layout = new PatternLayout("%p - %m%n");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)os);
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.WARN);
        logger.setAdditivity(false);
        File file = new File("target/testReload.properties");
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        out.write("string=value1");
        out.flush();
        out.close();
        PropertiesConfiguration config = new PropertiesConfiguration("target/testReload.properties");
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(500L);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        Assert.assertEquals((String)"Initial value", (Object)"value1", (Object)config.getString("string"));
        Thread.sleep(2000L);
        file.delete();
        Assert.assertEquals((String)"Initial value", (Object)"value1", (Object)config.getString("string"));
        logger.removeAppender((Appender)appender);
        String str = os.toString();
        Assert.assertTrue((String)"No error was logged", (str != null && str.length() > 0 ? 1 : 0) != 0);
    }
}

