/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPropertiesConfigurationLayout {
    private static final String CR = System.getProperty("line.separator");
    private static final String CRNORM = "\n";
    static final String TEST_KEY = "myProperty";
    static final String TEST_COMMENT = "A comment for my test property";
    static final String TEST_VALUE = "myPropertyValue";
    PropertiesConfigurationLayout layout;
    LayoutTestConfiguration config;
    PropertiesBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.config = new LayoutTestConfiguration();
        this.layout = new PropertiesConfigurationLayout((PropertiesConfiguration)this.config);
        this.config.setLayout(this.layout);
        this.builder = new PropertiesBuilder();
    }

    @Test
    public void testInit() {
        Assert.assertTrue((String)"Object contains keys", (boolean)this.layout.getKeys().isEmpty());
        Assert.assertNull((String)"Header comment not null", (Object)this.layout.getHeaderComment());
        Iterator it = this.config.getConfigurationListeners().iterator();
        Assert.assertTrue((String)"No event listener registered", (boolean)it.hasNext());
        Assert.assertSame((String)"Layout not registered as event listener", (Object)this.layout, it.next());
        Assert.assertFalse((String)"Multiple event listeners registered", (boolean)it.hasNext());
        Assert.assertSame((String)"Configuration not stored", (Object)((Object)this.config), (Object)this.layout.getConfiguration());
        Assert.assertFalse((String)"Force single line flag set", (boolean)this.layout.isForceSingleLine());
        Assert.assertNull((String)"Got a global separator", (Object)this.layout.getGlobalSeparator());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNull() {
        new PropertiesConfigurationLayout(null);
    }

    @Test
    public void testReadSimple() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        Assert.assertNull((String)"A header comment was found", (Object)this.layout.getHeaderComment());
        Assert.assertEquals((String)"Wrong number of properties", (long)1L, (long)this.layout.getKeys().size());
        Assert.assertTrue((String)"Property not found", (boolean)this.layout.getKeys().contains(TEST_KEY));
        Assert.assertEquals((String)"Comment not found", (Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assert.assertEquals((String)"Wrong number of blanc lines", (long)0L, (long)this.layout.getBlancLinesBefore(TEST_KEY));
        Assert.assertTrue((String)"Wrong single line flag", (boolean)this.layout.isSingleLine(TEST_KEY));
        Assert.assertEquals((String)"Property not stored in config", (Object)TEST_VALUE, (Object)this.config.getString(TEST_KEY));
    }

    @Test
    public void testBlancLines() throws ConfigurationException {
        this.builder.addProperty("prop", "value");
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong number of blanc lines", (long)2L, (long)this.layout.getBlancLinesBefore(TEST_KEY));
        Assert.assertEquals((String)"Wrong comment", (Object)"A comment for my test property\n", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assert.assertEquals((String)"Wrong property value", (Object)TEST_VALUE, (Object)this.config.getString(TEST_KEY));
    }

    @Test
    public void testIsSingleLine() throws ConfigurationException {
        this.builder.addProperty(TEST_KEY, "myPropertyValue,myPropertyValue2");
        this.layout.load(this.builder.getReader());
        Assert.assertTrue((String)"Wrong single line flag", (boolean)this.layout.isSingleLine(TEST_KEY));
        Assert.assertEquals((String)"Wrong number of values", (long)2L, (long)this.config.getList(TEST_KEY).size());
    }

    @Test
    public void testIsSingleLineMulti() throws ConfigurationException {
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addProperty("anotherProp", "a value");
        this.builder.addProperty(TEST_KEY, "myPropertyValue2");
        this.layout.load(this.builder.getReader());
        Assert.assertFalse((String)"Wrong single line flag", (boolean)this.layout.isSingleLine(TEST_KEY));
        Assert.assertEquals((String)"Wrong number of values", (long)2L, (long)this.config.getList(TEST_KEY).size());
    }

    @Test
    public void testCombineComments() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, "myPropertyValue2");
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong combined comment", (Object)"A comment for my test property\nA comment for my test property", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
        Assert.assertEquals((String)"Wrong combined blanc numbers", (long)0L, (long)this.layout.getBlancLinesBefore(TEST_KEY));
    }

    @Test
    public void testHeaderComment() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong header comment", (Object)TEST_COMMENT, (Object)this.layout.getCanonicalHeaderComment(false));
        Assert.assertNull((String)"Wrong comment for property", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    public void testHeaderCommentWithBlancs() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong header comment", (Object)"A comment for my test property\n\nA comment for my test property", (Object)this.layout.getCanonicalHeaderComment(false));
        Assert.assertNull((String)"Wrong comment for property", (Object)this.layout.getComment(TEST_KEY));
    }

    @Test
    public void testHeaderCommentWithBlancsAndPropComment() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong header comment", (Object)"A comment for my test property\n\nA comment for my test property", (Object)this.layout.getCanonicalHeaderComment(false));
        Assert.assertEquals((String)"Wrong comment for property", (Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    public void testHeaderCommentNull() {
        Assert.assertNull((String)"No null comment with comment chars", (Object)this.layout.getCanonicalHeaderComment(true));
        Assert.assertNull((String)"No null comment without comment chars", (Object)this.layout.getCanonicalHeaderComment(false));
    }

    @Test
    public void testEventAdd() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 1, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.configurationChanged(event);
        Assert.assertTrue((String)"Property not stored", (boolean)this.layout.getKeys().contains(TEST_KEY));
        Assert.assertEquals((String)"Blanc lines before new property", (long)0L, (long)this.layout.getBlancLinesBefore(TEST_KEY));
        Assert.assertTrue((String)"No single line property", (boolean)this.layout.isSingleLine(TEST_KEY));
        Assert.assertEquals((String)"Wrong separator", (Object)" = ", (Object)this.layout.getSeparator(TEST_KEY));
    }

    @Test
    public void testEventAddMultiple() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 1, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.configurationChanged(event);
        this.layout.configurationChanged(event);
        Assert.assertFalse((String)"No multi-line property", (boolean)this.layout.isSingleLine(TEST_KEY));
    }

    @Test
    public void testEventAddExisting() throws ConfigurationException {
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.load(this.builder.getReader());
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 1, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.configurationChanged(event);
        Assert.assertFalse((String)"No multi-line property", (boolean)this.layout.isSingleLine(TEST_KEY));
        Assert.assertEquals((String)"Comment was modified", (Object)TEST_COMMENT, (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    public void testEventSetNonExisting() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 3, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.configurationChanged(event);
        Assert.assertTrue((String)"New property was not found", (boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    public void testEventDelete() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 1, TEST_KEY, (Object)TEST_VALUE, false);
        this.layout.configurationChanged(event);
        event = new ConfigurationEvent((Object)this, 2, TEST_KEY, null, false);
        this.layout.configurationChanged(event);
        Assert.assertFalse((String)"Property still existing", (boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    public void testEventClearConfig() throws Exception {
        this.fillLayout();
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 4, null, null, false);
        this.layout.configurationChanged(event);
        Assert.assertTrue((String)"Keys not empty", (boolean)this.layout.getKeys().isEmpty());
        Assert.assertNull((String)"Header comment was not reset", (Object)this.layout.getHeaderComment());
    }

    @Test
    public void testEventAddBefore() {
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 1, TEST_KEY, (Object)TEST_VALUE, true);
        this.layout.configurationChanged(event);
        Assert.assertFalse((String)"Property already stored", (boolean)this.layout.getKeys().contains(TEST_KEY));
    }

    @Test
    public void testEventReload() {
        this.fillLayout();
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 20, null, null, true);
        this.layout.configurationChanged(event);
        Assert.assertTrue((String)"Keys not empty", (boolean)this.layout.getKeys().isEmpty());
        Assert.assertNull((String)"Header comment was not reset", (Object)this.layout.getHeaderComment());
    }

    @Test
    public void testEventReloadAfter() {
        this.fillLayout();
        ConfigurationEvent event = new ConfigurationEvent((Object)this, 20, null, null, false);
        this.layout.configurationChanged(event);
        Assert.assertFalse((String)"Keys are empty", (boolean)this.layout.getKeys().isEmpty());
        Assert.assertNotNull((String)"Header comment was reset", (Object)this.layout.getHeaderComment());
    }

    @Test
    public void testRecursiveLoadCall() throws ConfigurationException {
        PropertiesBuilder b = new PropertiesBuilder();
        b.addComment("A nested header comment.");
        b.addComment("With multiple lines");
        b.addComment(null);
        b.addComment("Second comment");
        b.addProperty(TEST_KEY, TEST_VALUE);
        b.addProperty("myProperty2", "myPropertyValue2");
        this.config.builder = b;
        this.builder.addComment("Header comment");
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addComment("Include file");
        this.builder.addProperty(PropertiesConfiguration.getInclude(), "test");
        this.layout.load(this.builder.getReader());
        Assert.assertEquals((String)"Wrong header comment", (Object)"Header comment", (Object)this.layout.getCanonicalHeaderComment(false));
        Assert.assertFalse((String)"Include property was stored", (boolean)this.layout.getKeys().contains(PropertiesConfiguration.getInclude()));
        Assert.assertEquals((String)"Wrong comment for property", (Object)"A comment for my test property\nA nested header comment.\nWith multiple lines\n\nSecond comment", (Object)this.layout.getCanonicalComment(TEST_KEY, false));
    }

    @Test
    public void testReadAndWrite() throws ConfigurationException {
        this.builder.addComment("This is my test properties file,");
        this.builder.addComment("which contains a header comment.");
        this.builder.addComment(null);
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_COMMENT);
        this.builder.addComment(null);
        this.builder.addComment(null);
        this.builder.addComment("Another comment");
        this.builder.addProperty("property", "and a value");
        this.layout.load(this.builder.getReader());
        this.checkLayoutString(this.builder.toString());
    }

    @Test
    public void testSave() throws ConfigurationException {
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.config.addProperty(TEST_KEY, "myPropertyValue2");
        this.config.addProperty("AnotherProperty", "AnotherValue");
        this.config.addProperty("AnotherProperty", "3rdValue");
        this.layout.setComment("AnotherProperty", "AnotherComment");
        this.layout.setBlancLinesBefore("AnotherProperty", 2);
        this.layout.setSingleLine("AnotherProperty", true);
        this.layout.setHeaderComment("A header comment\nfor my properties");
        this.checkLayoutString("# A header comment" + CR + "# for my properties" + CR + CR + "# " + TEST_COMMENT + CR + TEST_KEY + " = " + TEST_VALUE + CR + TEST_KEY + " = " + TEST_VALUE + "2" + CR + CR + CR + "# AnotherComment" + CR + "AnotherProperty = AnotherValue,3rdValue" + CR);
    }

    @Test
    public void testSaveForceSingleLine() throws ConfigurationException {
        this.config.setListDelimiter(';');
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.config.addProperty(TEST_KEY, "myPropertyValue2");
        this.config.addProperty("AnotherProperty", "value1;value2;value3");
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.layout.setForceSingleLine(true);
        this.checkLayoutString("# A comment for my test property" + CR + TEST_KEY + " = " + TEST_VALUE + ';' + TEST_VALUE + "2" + CR + "AnotherProperty = value1;value2;value3" + CR);
    }

    @Test
    public void testTrimComment() {
        Assert.assertEquals((String)"Wrong trimmed comment", (Object)("This is a comment" + CR + "that spans multiple" + CR + "lines in a" + CR + " complex way."), (Object)PropertiesConfigurationLayout.trimComment((String)("   # This is a comment" + CR + "that spans multiple" + CR + "!lines in a" + CR + " complex way."), (boolean)false));
    }

    @Test
    public void testTrimCommentTrainlingCR() {
        Assert.assertEquals((String)"Wrong trimmed comment", (Object)("Comment with" + CR + "trailing CR" + CR), (Object)PropertiesConfigurationLayout.trimComment((String)("Comment with" + CR + "! trailing CR" + CR), (boolean)false));
    }

    @Test
    public void testTrimCommentFalse() {
        Assert.assertEquals((String)"Wrong trimmed comment", (Object)("# Comment with" + CR + " ! some mixed " + CR + "#comment" + CR + "# lines"), (Object)PropertiesConfigurationLayout.trimComment((String)("Comment with" + CR + " ! some mixed " + CR + "#comment" + CR + "lines"), (boolean)true));
    }

    @Test
    public void testGetNonExistingLayouData() {
        Assert.assertNull((String)"A comment was found", (Object)this.layout.getComment("unknown"));
        Assert.assertTrue((String)"A multi-line property", (boolean)this.layout.isSingleLine("unknown"));
        Assert.assertEquals((String)"Leading blanc lines", (long)0L, (long)this.layout.getBlancLinesBefore("unknown"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNullLayouttData() {
        this.layout.setComment(null, TEST_COMMENT);
    }

    @Test
    public void testSetNullComment() {
        this.fillLayout();
        this.layout.setComment(TEST_KEY, null);
        Assert.assertNull((String)"Comment was not reset", (Object)this.layout.getComment(TEST_KEY));
    }

    @Test
    public void testSaveCommentForUnexistingProperty() throws ConfigurationException {
        this.fillLayout();
        this.layout.setComment("NonExistingKey", "NonExistingComment");
        String output = this.getLayoutString();
        Assert.assertTrue((String)"Non existing key was found", (output.indexOf("NonExistingKey") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Non existing comment was found", (output.indexOf("NonExistingComment") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSaveEmptyLayout() throws ConfigurationException {
        this.checkLayoutString("");
    }

    @Test
    public void testInitCopy() {
        this.fillLayout();
        PropertiesConfigurationLayout l2 = new PropertiesConfigurationLayout((PropertiesConfiguration)this.config, this.layout);
        Assert.assertEquals((String)"Wrong number of keys", (long)this.layout.getKeys().size(), (long)l2.getKeys().size());
        for (String key : this.layout.getKeys()) {
            Assert.assertTrue((String)("Key was not found: " + key), (boolean)l2.getKeys().contains(key));
        }
        Assert.assertEquals((String)"Wrong header comment", (Object)this.layout.getHeaderComment(), (Object)l2.getHeaderComment());
        Assert.assertEquals((String)"Wrong footer comment", (Object)this.layout.getFooterComment(), (Object)l2.getFooterComment());
    }

    @Test
    public void testInitCopyModify() {
        this.fillLayout();
        PropertiesConfigurationLayout l2 = new PropertiesConfigurationLayout((PropertiesConfiguration)this.config, this.layout);
        Assert.assertEquals((String)"Comments are not equal", (Object)this.layout.getComment(TEST_KEY), (Object)l2.getComment(TEST_KEY));
        this.layout.setComment(TEST_KEY, "A new comment");
        Assert.assertEquals((String)"Comment was changed", (Object)TEST_COMMENT, (Object)l2.getCanonicalComment(TEST_KEY, false));
        l2.setBlancLinesBefore(TEST_KEY, l2.getBlancLinesBefore(TEST_KEY) + 1);
        Assert.assertFalse((String)"Blanc lines do not differ", (this.layout.getBlancLinesBefore(TEST_KEY) == l2.getBlancLinesBefore(TEST_KEY) ? 1 : 0) != 0);
    }

    @Test
    public void testSetSeparator() throws ConfigurationException {
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setSeparator(TEST_KEY, ":");
        this.checkLayoutString("myProperty:myPropertyValue" + CR);
    }

    @Test
    public void testSetGlobalSeparator() throws ConfigurationException {
        String sep = "=";
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.config.addProperty("key2", "value2");
        this.layout.setSeparator(TEST_KEY, " : ");
        this.layout.setGlobalSeparator("=");
        this.checkLayoutString("myProperty=myPropertyValue" + CR + "key2" + "=" + "value2" + CR);
    }

    @Test
    public void testSetLineSeparator() throws ConfigurationException {
        String lf = CR + CR;
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setBlancLinesBefore(TEST_KEY, 2);
        this.layout.setComment(TEST_KEY, TEST_COMMENT);
        this.layout.setHeaderComment("Header comment");
        this.layout.setLineSeparator(lf);
        this.checkLayoutString("# Header comment" + lf + lf + lf + lf + "# " + TEST_COMMENT + lf + TEST_KEY + " = " + TEST_VALUE + lf);
    }

    @Test
    public void testSetLineSeparatorInComments() throws ConfigurationException {
        String lf = "<-\n";
        this.config.addProperty(TEST_KEY, TEST_VALUE);
        this.layout.setComment(TEST_KEY, "A comment for my test property\nMore comment");
        this.layout.setHeaderComment("Header\ncomment");
        this.layout.setLineSeparator("<-\n");
        this.checkLayoutString("# Header<-\n# comment<-\n<-\n# A comment for my test property<-\n# More comment<-\nmyProperty = myPropertyValue<-\n");
    }

    private void fillLayout() {
        this.builder.addComment("A header comment");
        this.builder.addComment(null);
        this.builder.addProperty("prop", "value");
        this.builder.addComment(TEST_COMMENT);
        this.builder.addProperty(TEST_KEY, TEST_VALUE);
        this.builder.addProperty("anotherProp", "anotherValue");
        this.builder.addComment("A footer comment");
        try {
            this.layout.load(this.builder.getReader());
        }
        catch (ConfigurationException cex) {
            Assert.fail((String)("Exception was thrown: " + (Object)((Object)cex)));
        }
    }

    private String getLayoutString() throws ConfigurationException {
        StringWriter out = new StringWriter();
        this.layout.save((Writer)out);
        return out.toString();
    }

    private void checkLayoutString(String expected) throws ConfigurationException {
        Assert.assertEquals((String)"Wrong layout file content", (Object)expected, (Object)this.getLayoutString());
    }

    static class LayoutTestConfiguration
    extends PropertiesConfiguration {
        public PropertiesBuilder builder;

        LayoutTestConfiguration() {
        }

        boolean propertyLoaded(String key, String value) throws ConfigurationException {
            if (this.builder == null) {
                return super.propertyLoaded(key, value);
            }
            if (PropertiesConfiguration.getInclude().equals(key)) {
                this.getLayout().load(this.builder.getReader());
                return false;
            }
            return true;
        }
    }

    static class PropertiesBuilder {
        private StringBuilder buf = new StringBuilder();
        private int commentCounter;

        PropertiesBuilder() {
        }

        public void addProperty(String key, String value) {
            this.buf.append(key).append(" = ").append(value).append(CR);
        }

        public void addComment(String s) {
            if (s != null) {
                if (this.commentCounter % 2 == 0) {
                    this.buf.append("# ");
                } else {
                    this.buf.append("! ");
                }
                this.buf.append(s);
                ++this.commentCounter;
            }
            this.buf.append(CR);
        }

        public Reader getReader() {
            return new StringReader(this.buf.toString());
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

