/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileMonitor;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public class DefaultFileMonitor
implements Runnable,
FileMonitor {
    private static final Log LOG = LogFactory.getLog(DefaultFileMonitor.class);
    private static final long DEFAULT_DELAY = 1000L;
    private static final int DEFAULT_MAX_FILES = 1000;
    private final Map<FileName, FileMonitorAgent> monitorMap = new HashMap<FileName, FileMonitorAgent>();
    private Thread monitorThread;
    private final Stack<FileObject> deleteStack = new Stack();
    private final Stack<FileObject> addStack = new Stack();
    private volatile boolean shouldRun = true;
    private boolean recursive;
    private long delay = 1000L;
    private int checksPerRun = 1000;
    private final FileListener listener;

    public DefaultFileMonitor(FileListener listener) {
        this.listener = listener;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    FileListener getFileListener() {
        return this.listener;
    }

    @Override
    public void addFile(FileObject file) {
        this.doAddFile(file);
        try {
            if (file.getType().hasChildren()) {
                FileObject[] children;
                for (FileObject element : children = file.getChildren()) {
                    this.doAddFile(element);
                }
            }
        }
        catch (FileSystemException fse) {
            LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddFile(FileObject file) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(file.getName()) == null) {
                this.monitorMap.put(file.getName(), new FileMonitorAgent(this, file));
                try {
                    if (this.listener != null) {
                        file.getFileSystem().addListener(file, this.listener);
                    }
                    if (file.getType().hasChildren() && this.recursive) {
                        FileObject[] children;
                        for (FileObject element : children = file.getChildren()) {
                            this.addFile(element);
                        }
                    }
                }
                catch (FileSystemException fse) {
                    LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(FileObject file) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            FileName fn = file.getName();
            if (this.monitorMap.get(fn) != null) {
                FileMonitorAgent parentAgent;
                FileObject parent;
                try {
                    parent = file.getParent();
                }
                catch (FileSystemException fse) {
                    parent = null;
                }
                this.monitorMap.remove(fn);
                if (parent != null && (parentAgent = this.monitorMap.get(parent.getName())) != null) {
                    parentAgent.resetChildrenList();
                }
            }
        }
    }

    protected void queueRemoveFile(FileObject file) {
        this.deleteStack.push(file);
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay > 0L ? delay : 1000L;
    }

    public int getChecksPerRun() {
        return this.checksPerRun;
    }

    public void setChecksPerRun(int checksPerRun) {
        this.checksPerRun = checksPerRun;
    }

    protected void queueAddFile(FileObject file) {
        this.addStack.push(file);
    }

    public void start() {
        if (this.monitorThread == null) {
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setPriority(1);
        }
        this.monitorThread.start();
    }

    public void stop() {
        this.shouldRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (!this.monitorThread.isInterrupted() && this.shouldRun) {
            Object[] fileNames;
            Map<FileName, FileMonitorAgent> map = this.monitorMap;
            synchronized (map) {
                fileNames = this.monitorMap.keySet().toArray();
            }
            for (int iterFileNames = 0; iterFileNames < fileNames.length; ++iterFileNames) {
                FileMonitorAgent agent;
                FileName fileName = (FileName)fileNames[iterFileNames];
                Map<FileName, FileMonitorAgent> map2 = this.monitorMap;
                synchronized (map2) {
                    agent = this.monitorMap.get(fileName);
                }
                if (agent != null) {
                    agent.check();
                }
                if (this.getChecksPerRun() > 0 && (iterFileNames + 1) % this.getChecksPerRun() == 0) {
                    try {
                        Thread.sleep(this.getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.monitorThread.isInterrupted() || !this.shouldRun) continue block10;
            }
            while (!this.addStack.empty()) {
                this.addFile(this.addStack.pop());
            }
            while (!this.deleteStack.empty()) {
                this.removeFile(this.deleteStack.pop());
            }
            try {
                Thread.sleep(this.getDelay());
            }
            catch (InterruptedException e) {}
        }
        this.shouldRun = true;
    }

    private static final class FileMonitorAgent {
        private final FileObject file;
        private final DefaultFileMonitor fm;
        private boolean exists;
        private long timestamp;
        private Map<FileName, Object> children;

        private FileMonitorAgent(DefaultFileMonitor fm, FileObject file) {
            this.fm = fm;
            this.file = file;
            this.refresh();
            this.resetChildrenList();
            try {
                this.exists = this.file.exists();
            }
            catch (FileSystemException fse) {
                this.exists = false;
                this.timestamp = -1L;
            }
            if (this.exists) {
                try {
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                }
                catch (FileSystemException fse) {
                    this.timestamp = -1L;
                }
            }
        }

        private void resetChildrenList() {
            try {
                if (this.file.getType().hasChildren()) {
                    FileObject[] childrenList;
                    this.children = new HashMap<FileName, Object>();
                    for (FileObject element : childrenList = this.file.getChildren()) {
                        this.children.put(element.getName(), new Object());
                    }
                }
            }
            catch (FileSystemException fse) {
                this.children = null;
            }
        }

        private void refresh() {
            try {
                this.file.refresh();
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void fireAllCreate(FileObject child) {
            if (this.fm.getFileListener() != null) {
                child.getFileSystem().addListener(child, this.fm.getFileListener());
            }
            ((AbstractFileSystem)child.getFileSystem()).fireFileCreated(child);
            if (this.fm.getFileListener() != null) {
                child.getFileSystem().removeListener(child, this.fm.getFileListener());
            }
            this.fm.queueAddFile(child);
            try {
                if (this.fm.isRecursive() && child.getType().hasChildren()) {
                    FileObject[] newChildren;
                    for (FileObject element : newChildren = child.getChildren()) {
                        this.fireAllCreate(element);
                    }
                }
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void checkForNewChildren() {
            try {
                if (this.file.getType().hasChildren()) {
                    FileObject[] newChildren = this.file.getChildren();
                    if (this.children != null) {
                        HashMap<FileName, Object> newChildrenMap = new HashMap<FileName, Object>();
                        Stack<FileObject> missingChildren = new Stack<FileObject>();
                        for (int i = 0; i < newChildren.length; ++i) {
                            newChildrenMap.put(newChildren[i].getName(), new Object());
                            if (this.children.containsKey(newChildren[i].getName())) continue;
                            missingChildren.push(newChildren[i]);
                        }
                        this.children = newChildrenMap;
                        if (!missingChildren.empty()) {
                            while (!missingChildren.empty()) {
                                FileObject child = (FileObject)missingChildren.pop();
                                this.fireAllCreate(child);
                            }
                        }
                    } else {
                        if (newChildren.length > 0) {
                            this.children = new HashMap<FileName, Object>();
                        }
                        for (FileObject element : newChildren) {
                            this.children.put(element.getName(), new Object());
                            this.fireAllCreate(element);
                        }
                    }
                }
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }

        private void check() {
            this.refresh();
            try {
                if (this.exists && !this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = -1L;
                    ((AbstractFileSystem)this.file.getFileSystem()).fireFileDeleted(this.file);
                    if (this.fm.getFileListener() != null) {
                        this.file.getFileSystem().removeListener(this.file, this.fm.getFileListener());
                    }
                    this.fm.queueRemoveFile(this.file);
                } else if (this.exists && this.file.exists()) {
                    if (this.timestamp != this.file.getContent().getLastModifiedTime()) {
                        this.timestamp = this.file.getContent().getLastModifiedTime();
                        if (!this.file.getType().hasChildren()) {
                            ((AbstractFileSystem)this.file.getFileSystem()).fireFileChanged(this.file);
                        }
                    }
                } else if (!this.exists && this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                    if (!this.file.getType().hasChildren()) {
                        ((AbstractFileSystem)this.file.getFileSystem()).fireFileCreated(this.file);
                    }
                }
                this.checkForNewChildren();
            }
            catch (FileSystemException fse) {
                LOG.error((Object)fse.getLocalizedMessage(), (Throwable)fse);
            }
        }
    }
}

